### Overview
- Each listener on the Cisco Secure Email Gateway requires a set of rules to control incoming connections from remote hosts.
- The Host Access Table (HAT) is used to define which hosts can connect to a listener.
### Host Access Table (HAT)
##### Purpose
- Controls incoming connections for each listener.
- Configures settings for both public and private listeners.
##### Default Settings
- **Public Listener**: Accepts email from all external hosts.
- **Private Listener**: Relays email only from specified internal hosts; all others are rejected.
##### Configuration Components
- **Sender Groups**: Defines remote hosts attempting to connect, based on criteria like IP address, domain, or SenderBase Reputation Score (SBRS).
- **Mail Flow Policies**: Determines connection permissions and conditions for sender groups.
##### Connection Process
- When a TCP connection is received, the listener checks the source IP against sender groups in order.
- If a match is found, the configured mail flow policy is applied.

### Sender Groups
![[Pasted image 20250413192351.png]]
##### Definition
- Groups remote hosts for uniform email processing.
- Identified by IP, domain, SBRS (SenderBase Reputation Score), or other parameters.
##### Predefined vs. Custom
- Predefined groups come with corresponding mail flow policies.
- Custom groups can be created for specific requirements.
##### SBRS
- Numeric value (-10.0 to +10.0) indicating sender trustworthiness.
- Used to classify senders and apply appropriate actions.
##### External Threat Feeds (ETF)
- Introduced in AsyncOS version 12.
- Allows integration of external threat information in STIX format to preemptively respond to threats.

### Mail Flow Policies

**Incoming**: 
![[Pasted image 20250413192837.png]]

**Outgoing**: 
![[Pasted image 20250413192946.png]]
##### Actions
- **Accept**: Allows connection and applies further listener settings.
- **Reject**: Connection accepted but email is denied with an SMTP code.
- **TCP Refuse**: Connection is refused at the TCP level.
- **Relay**: Connection accepted without RAT constraints.
- **Continue**: Ignores current mapping and continues HAT processing.
#### Parameters
- Define connection, rate limiting, SMTP codes, spam/virus detection, encryption, and authentication settings.

### Deployment Scenarios

##### Two-Interface Deployment
- Uses separate HAT tables for public and private listeners.
- Public listener handles incoming emails; private listener manages outgoing emails.
##### Single Interface Deployment
- Utilizes a single HAT table for both inbound and outbound traffic.
- Simplifies configuration for smaller networks.

### Common Issues and Solutions

##### Reputation Challenges
- Poor sender reputation scores can lead to unnecessary email blocking.
- Temporary solutions include adding trusted domains to ALLOWED_LIST or creating a specific sender group.
##### Outgoing Email Rejection
- Ensure local domains are correctly configured in RELAYLIST for private listeners to allow outbound emails.

### Best Practices
- Carefully configure sender groups and mail flow policies to fit enterprise needs.
- Regularly review and update HAT settings to ensure proper email flow and security.